/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.menu;

import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.menu.CardSlot;
import java.util.ArrayList;
import java.util.function.Function;

public class HandSlot<G extends CardGame<G>>
extends CardSlot<G> {
    protected final Function<G, GameSlot> censored = g -> g.getCensoredHand(player);

    public HandSlot(G game, CardPlayer player, float x, float y) {
        super(game, (G g) -> g.getPlayerHand(player), x, y);
    }

    public HandSlot(G game, CardPlayer player, float x, float y, CardSlot.Type type) {
        super(game, (G g) -> g.getPlayerHand(player), x, y, type);
    }

    public final GameSlot getCensoredSlot() {
        return this.censored.apply(this.game);
    }

    @Override
    protected void onUpdate() {
        GameSlot censored = this.getCensoredSlot();
        Iterable<Card> cards = this.getSlot().getCards();
        ArrayList<Card> censoredCards = new ArrayList<Card>();
        cards.forEach(c -> censoredCards.add(Card.BLANK));
        censored.setCards(censoredCards);
    }
}

